@echo off
setlocal enabledelayedexpansion

REM Wykrywanie adresu IP (ignoruje 127.x.x.x i 169.254.x.x)
set BASEIP=
set MYHOST=
set ip=

for /f "tokens=2 delims=:" %%a in ('ipconfig ^| findstr /I /R /C:"IPv4 Address" /C:"Adres IPv4"') do (
    set currentip=%%a
    set currentip=!currentip:~1!
    echo !currentip! | findstr /V "127.0.0.1 169.254." >nul
    if not errorlevel 1 (
        set ip=!currentip!
    )
)
for /f "tokens=1-4 delims=." %%a in ("%ip%") do (
    set BASEIP=%%a.%%b.%%c
    set MYHOST=%%d
)

if "%BASEIP%"=="" (
    echo Nie wykryto adresu IP. Sprawdz polaczenie sieciowe.
    pause
    exit /b
)

echo Twoj IP: %ip%

set MAX=254
set BARLEN=20

echo Skanowanie sieci %BASEIP%.1-%MAX% ...
echo.

set lastpercent=0

for /L %%i in (1,1,%MAX%) do (
    if NOT "%%i"=="%MYHOST%" (
        set /a percent=100*%%i/%MAX%
        if NOT "!percent!"=="!lastpercent!" (
            set /a bars=!percent!/5
            set barstr=
            for /L %%b in (1,1,!bars!) do set barstr=!barstr!=
            for /L %%b in (!bars!,1,%BARLEN%) do set barstr=!barstr!-
            echo Progress: [!barstr!] !percent!%%
            set lastpercent=!percent!
        )
        ping -n 1 -w 10 %BASEIP%.%%i >nul
    )
)

echo.

arp -a > arp-table.txt
echo --------------------------------------------
echo Znaleziono nastepujace urzadzenia NIPPY:
echo --------------------------------------------

set found=0

for /f "tokens=1,2,3 delims= " %%a in (arp-table.txt) do (
    set ip=%%a
    set mac=%%b
    if /i "!mac:~0,8!"=="00-14-78" (
        echo IP: !ip!  MAC: !mac!
        set found=1
    )
    if /i "!mac:~0,8!"=="02-14-78" (
        echo IP: !ip!  MAC: !mac!
        set found=1
    )
)

if "!found!"=="0" (
    echo Nie znaleziono urzadzenia NIPPY.
)

del arp-table.txt

echo.
echo Nacisnij dowolny klawisz, aby zakonczyc...
pause >nul
